% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.lhss}
\alias{summary.lhss}
\title{Extract summary from \code{lhss} object, including two-sample significance
test for homogeneity of the numerator and denominator samples}
\usage{
\method{summary}{lhss}(
  object,
  test = FALSE,
  n_perm = 100,
  parallel = FALSE,
  cluster = NULL,
  ...
)
}
\arguments{
\item{object}{Object of class \code{lhss}}

\item{test}{logical indicating whether to statistically test for homogeneity
of the numerator and denominator samples.}

\item{n_perm}{Scalar indicating number of permutation samples}

\item{parallel}{\code{logical} indicating to run the permutation test in parallel}

\item{cluster}{\code{NULL} or a cluster object created by \code{makeCluster}.
If \code{NULL} and \code{parallel = TRUE}, it uses the number of available
cores minus 1.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Summary of the fitted density ratio model
}
\description{
Extract summary from \code{lhss} object, including two-sample significance
test for homogeneity of the numerator and denominator samples
}
\examples{
set.seed(123)
# Fit model (minimal example to limit computation time)
dr <- lhss(numerator_small, denominator_small,
           nsigma = 5, nlambda = 3, ncenters = 50, maxit = 100)
# Inspect model object
dr
# Obtain summary of model object
summary(dr)
# Plot model object
plot(dr)
# Plot density ratio for each variable individually
plot_univariate(dr)
# Plot density ratio for each pair of variables
plot_bivariate(dr)
# Predict density ratio and inspect first 6 predictions
head(predict(dr))
}
