% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{ROIcoeffs}
\alias{ROIcoeffs}
\title{Compute the Return on Investment (ROI) surface coefficients from population probabilities}
\usage{
ROIcoeffs(probabilities, As = 5:20, Ls = (diff(range(As)) + 1):1)
}
\arguments{
\item{probabilities, }{a \code{\link[base]{data.frame}} (or \code{\link[data.table]{data.table}}) with the probabilities resulting from \link{nPxA}. Rows must correspond to ages, starting with age 1}

\item{As, }{the starting age(s) to consider}

\item{Ls, }{the maximum number of tests for each age; should either be an integer per age or a single integer for all ages.
The default behavior computes the number of tests (for each age) that makes the maximum of `As` the maximum testing age
Note: results will also be provided for shorter testing intervals, as the intermediate coefficients are calculated as part
of computing the value at the maximum \code{L}}
}
\value{
a \code{\link[base]{data.frame}} (\code{\link[data.table]{data.table}}, if available) with columns:
\describe{
  \item{A}{integer; the age when routine test-then-vaccinate strategy starts (from \code{As})}
  \item{L}{integer; the maximum number of tests for routine test-then-vaccinate strategy (from \code{Ls})}
  \item{vacfrac}{numeric; the fraction of individuals participating in this strategy that get vaccinated}
  \item{pri.offset}{numeric; the (additive) reduction in \code{vacfrac} if using the ordinal test}
  \item{Sfrac}{numeric; the proportion experiencing second infection costs}
  \item{Fresp}{numeric; the F/S cost fraction term, when comparing vaccination with and without testing}
  \item{Sgain}{numeric; the S term, when comparing vaccination with and without testing}
}
}
\description{
Compute the Return on Investment (ROI) surface coefficients from population probabilities
}
\details{
computes the coefficients for the economic calculations
}
\examples{
require(denvax);
data(morrison2010) # has counts by age
fit <- with(morrison2010, serofit(sero=Seropositive, N=Number, age.min=Age))
m2010pop <- synthetic.pop(fit, runs = 10, popsize = 10) # small sample size for example run time
m2010lh <- nPxA(m2010pop)
rc <- ROIcoeffs(m2010lh, As=5:10, Ls=5)
pp <- par()
par(mfrow=c(1, 2))
rcs <- subset(rc, A==10 & L < 11)
with(rcs, plot(
  L, aveTests, type="l",
  xlab="Max # of Tests Allowed",
  ylab="Ave # of Tests Administered",
  main="Starting @ Age 10",
  ylim=c(1, 3)
))
rcs <- subset(rc, A==5 & L < 11)
with(rcs, plot(
  L, aveTests, type="l",
  xlab="Max # of Tests Allowed",
  ylab="",
  main="Starting @ Age 5",
  ylim=c(1, 3)
))
par(pp)

}
