% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{build.project}
\alias{build.project}
\title{Creates an ROI estimation project.}
\usage{
build.project(targetdir, overwrite = FALSE, copy_pub = TRUE)
}
\arguments{
\item{targetdir, }{path to enclosing directory. If this directory does not exist, will attempt to create it (recursively)}

\item{overwrite, }{overwrite existing files corresponding to the project skeleton elements?}

\item{copy_pub, }{copy the `/pub` folder (which contains the analyses from the publication)}
}
\value{
logical, indicating error free creation of the project skeleton; there may still be other warnings
}
\description{
Creates an ROI estimation project.
}
\details{
This function sets up the skeleton of an analysis to go from seroprevalence data to the ROI estimation surface.
  That skeleton uses a series of separate scripts for each analytical step (fitting, simulation, analysis, and application),
  connected via the command line build tool \code{make}.  This approach allows clean substitution for various stages (e.g.,
  using a different model to generate life histories). The following files are created:
\describe{
  \item{Makefile}{the dependencies for various analysis stages}
  \item{README.md}{brief notes about project parts}
  \item{fit.R}{script for fitting seroprevalence data}
  \item{synthesize.R}{script for generating synthetic populations}
  \item{digest.R}{script for converting life histories into probability coefficients for ROI calculation}
  \item{simple.R}{a quick example start-to-finish analysis}
}
}
\examples{
require(denvax)
tardir <- tempdir() # replace with desired target
build.project(tardir)
list.files(tardir, recursive = TRUE)

}
