% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{synthetic.pop}
\alias{synthetic.pop}
\title{Compute synthetic population trajectories from model parameters}
\usage{
synthetic.pop(pars, runs = 100, popsize = 1000, maxAge = 70,
  rngseed = NULL)
}
\arguments{
\item{pars, }{a list with elements `f_H`, `f_L`, and `p_H`; see \link{serofit} return value}

\item{runs, }{the number of different serotype timelines to simulate}

\item{popsize, }{the number of individuals to sample for each run}

\item{maxAge, }{the length of each lifetime}

\item{rngseed, }{an optional seed for the random number generator}
}
\value{
a matrix of integers 0-4, rows `runs*popsize` x columns `maxAge`
}
\description{
Compute synthetic population trajectories from model parameters
}
\details{
Using fitted parameters for a two-risk, constant force of infection model,
  simulate a dengue annual exposures model for the requested number of serotype series (`runs`)
  and individuals (`popsize`).  The resulting matrix is a collection of integers, 0-4.
  0 indicates no infection, 1-4 infection by the corresponding serotype.
}
\examples{
require(denvax);
data(morrison2010) # has counts by age
fit <- with(morrison2010, serofit(sero=Seropositive, N=Number, age.min=Age))
m2010pop <- synthetic.pop(fit, runs = 10, popsize = 10) # small sample size for example run time
head(m2010pop)

}
