% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f-dist.R
\name{f_plot}
\alias{f_per}
\alias{f_plot}
\alias{f_prob}
\title{Visualize F Distribution}
\usage{
f_plot(num_df = 4, den_df = 30, normal = FALSE)

f_per(probs = 0.95, num_df = 3, den_df = 30, type = c("lower", "upper"))

f_prob(perc, num_df, den_df, type = c("lower", "upper"))
}
\arguments{
\item{num_df}{degrees of freedom associated with the numerator of f statistic}

\item{den_df}{degrees of freedom associated with the denominator of f statistic}

\item{normal}{logical; if \code{TRUE}, normal curve with same \code{mean} and
\code{sd} as the F distribution is drawn}

\item{probs}{a probability value}

\item{type}{lower tail or upper tail}

\item{perc}{a quantile value}
}
\value{
percentile for the \code{probs} based on \code{num_df}, \code{den_df}
and \code{type} or probability value for \code{perc} based on \code{num_df},
\code{den_df} and \code{type}
}
\description{
Visualize how changes in degrees of freedom affect the
shape of the F distribution. Compute\/visualize quantiles out of given
probability and probability from a given quantile.
}
\examples{
# visualize F distribution
f_plot()
f_plot(6, 10, normal = TRUE)

# compute\\/visualize probability from a given quantile
f_per(0.95, 3, 30, 'lower')
f_per(0.125, 9, 35, 'upper')

# compute\\/visualize quantiles out of given probability
f_prob(2.35, 5, 32)
f_prob(1.5222, 9, 35, type = "upper")
}
\seealso{
\code{\link[stats]{FDist}}
}

