% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_functions.R
\name{BV4.1}
\alias{BV4.1}
\title{Trend and Seasonality Estimation Using the Berlin Procedure 4.1}
\usage{
BV4.1(yt, type = NULL)
}
\arguments{
\item{yt}{a time series object of class \code{ts} or an object that can be 
converted into such an object with \code{\link[stats]{as.ts}}.}

\item{type}{a single character value that indicates, whether the data was
quarterly (\code{"quarterly"}) or monthly (\code{"monthly"}) observed; the 
default is \code{"monthly"}; if a time series object is passed to \code{yt},
the value for this argument will be automatically selected according to the 
frequency in \code{yt}.}
}
\value{
An S4 object with the following elements is returned.
\describe{
\item{\code{decomp}}{An object of class \code{"mts"} that consists of the
decomposed time series data.}
\item{\code{frequency}}{the frequency of the time series.}
\item{\code{ts_name}}{the object name of the initially provided time series object.}
}
}
\description{
Economic data can be decomposed into a trend, a seasonal and a remainder 
component using the Berlin procedure  4.1 (German: Berliner Verfahren 
4.1), as used by the National Statistical Office of Germany. Currently with 
this version of the R package, only the trend and seasonal components can be 
estimated following BV4.1. All further 
component estimations, for example the estimation of the
calendar component, of the official procedure BV4.1 are not yet implemented. 
The function supports quarterly and monthly data.
}
\details{
The BV4.1 base model is as follows:

trend and seasonality are estimated based on the additive
nonparametric regression model for an equidistant time series
\deqn{y_t = m(x_t) + s(x_t) + \epsilon_t,}
where \eqn{y_t} is the observed time series with \eqn{t=1,...n}, \eqn{x_t = t / n} is the rescaled time
on the interval \eqn{[0, 1]}, \eqn{m(x_t)} is a smooth trend function, 
\eqn{s(x_t)} is a (slowly changing) seasonal component with 
seasonal period \eqn{p_s} and \eqn{\epsilon_t} are stationary errors 
with \eqn{E(\epsilon_t) = 0} that are furthermore assumed to be independent 
but identically distributed (i.i.d.).

It is assumed that \eqn{m} and \eqn{s} can be approximated locally by a
polynomial of
small order and by a trigonometric polynomial, respectively. Through locally
weighted regression, \eqn{m} and \eqn{s} can therefore be estimated 
suitably.

The advantage of the Berlin Procedure 4.1 (BV4.1) is that it makes use of
fixed filters based on locally weighted regression (both with a weighted 
mixture of local linear and local cubic components for the trend) at all 
observation time points. Thus, BV4.1 results in fixed weighting matrices 
both for the trend estimation step and for the seasonality estimation step 
that can be immediately applied to all economic time series. 
Those matrices are saved internally in the package and when applying 
\code{\link{BV4.1}}, 
only weighted sums of the observations (with already obtained weights) have 
to be obtained at all time points. Thus, this procedure is quite fast.

Permission to include the BV4.1 base model procedure was kindly provided by 
the Federal Statistical Office of Germany.
}
\examples{

Xt <- log(EXPENDITURES)
est <- BV4.1(Xt)
est

}
\references{
\itemize{
\item{Speth, H.-T. (2004). Komponentenzerlegung und Saisonbereinigung ökonomischer 
Zeitreihen mit dem Verfahren BV4.1. Methodenberichte 3. Statistisches 
Bundesamt. URL: https://www.destatis.de/DE/Methoden/Saisonbereinigung/BV41-methodenbericht-Heft3_2004.pdf?__blob=publicationFile.}
}
}
\author{
\itemize{
\item Dominik Schulz (Research Assistant) (Department of Economics, Paderborn
University), \cr
Author and Package Creator
}
}
