% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_functions.R
\name{select_bwidth}
\alias{select_bwidth}
\title{Optimal Bandwidth Estimation for Locally Weighted Regression in Equidistant 
Time Series under Short Memory}
\usage{
select_bwidth(
  y,
  smoothing_options = set_options(),
  bwidth_start = NULL,
  inflation_rate = c("optimal", "naive"),
  correction_factor = FALSE,
  autocor = TRUE,
  drop = NULL,
  error_model = c("free", "ARMA"),
  nar_lim = c(0, 3),
  nma_lim = c(0, 3),
  arma_mean = FALSE
)
}
\arguments{
\item{y}{a numerical vector or a time series object of class \code{ts} or 
that can be transformed with \code{\link[stats]{as.ts}} to an object of class 
\code{ts}; for these observations, trend and seasonality will be obtained.}

\item{smoothing_options}{an S4 object of class \code{smoothing_options}, which 
is returned by the function \code{\link{set_options}}; it 
includes details about the
options to consider in the locally weighted regression such as the order of
polynomial and the bandwidth for smoothing among others.}

\item{bwidth_start}{a single numeric value that is only relevant if the slot
\code{bwidth} in \code{smoothing_options} is set to \code{NA}; 
as the bandwidth will then
be selected automatically, \code{bwidth_start} sets the initial bandwidth for 
the algorithm; the default, \code{bwidth_start = NULL}, corresponds to 
\code{bwidth_start = 0.1} for a local linear trend and to 
\code{bwidth_start = 0.2} for a local cubic trend.}

\item{inflation_rate}{a character vector of length one that indicates, which inflation rate 
to use in the bandwidth selection; for a local linear trend, we have 
\code{inflation_rate = "optimal"} as the default, for a local cubic trend
it is \code{inflation_rate = "naive"}, which correspond to inflation rates
of 5/7 and 9/13, respectively.}

\item{correction_factor}{A logical vector of length one; theoretically, a 
larger bandwidth to estimate the sum of autocovariances from residuals of 
pilot trend and seasonality estimates is advisable than for estimating trend
and seasonality; for \code{correction_factor = TRUE}, this is implemented; 
the default is \code{correction_factor = FALSE}, because it was found 
that setting this argument to \code{TRUE} often overestimates the 
bandwidth.}

\item{autocor}{a logical vector of length one; indicates whether to consider
autocorrelated errors (\code{TRUE}) or independent but identically 
distributed errors (\code{FALSE}); the default is \code{autocor = TRUE}.}

\item{drop}{a numeric vector of length one that indicates the proportion of 
the observations to not include at each boundary in the bandwidth estimation 
process, if a bandwidth is selected automatically; the default is 
\code{drop = NULL}, which corresponds to \code{drop = 0.05} for a 
local linear trend and to \code{drop = 0.1} for a local cubic trend.}

\item{error_model}{a character vector of length one that indicates whether
for \code{autocor = TRUE} the sum of autocovariances of the errors is 
obtained purely nonparametrically (\code{"free"}) or whether an
autoregressive moving-average (ARMA) model is assumed \code{"ARMA"}; the
default is \code{error_model = "free"}.}

\item{nar_lim}{only valid for \code{error_model = "ARMA"}; set the minimum and 
maximum AR order to check via the BIC in each iteration of the algorithm via 
a two-element vector.}

\item{nma_lim}{only valid for \code{error_model = "ARMA"}; set the minimum and
maximum MA order to check via the BIC in each iteration of the algorithm via
a two-element vector.}

\item{arma_mean}{only valid for \code{error_model = "ARMA"}; decide whether to 
include an estimate of the mean in the ARMA fitting for the detrended series.}
}
\value{
The function returns a list with different components:
\describe{
\item{\code{bopt}}{the obtained optimal bandwidth.}
\item{\code{bwidths}}{the obtained bandwidth for each iteration of the 
IPI-algorithm.}
\item{\code{Imk}}{the final estimate of \eqn{I[m^{(k)}]}.}
\item{\code{sum_autocov}}{the final estimate of the sum of autocovariances.}
}
}
\description{
Optimal Bandwidth Estimation for Locally Weighted Regression in Equidistant 
Time Series under Short Memory
}
\details{
See further details in the documentation of the function 
\code{\link[deseats]{deseats}}, where this function is applied internally
by default to select an optimal bandwidth.
}
\examples{
Xt <- log(EXPENDITURES)
select_bwidth(Xt)

}
\references{
\itemize{
\item{Feng, Y. (2013). An iterative plug-in algorithm for decomposing seasonal 
time series using the Berlin Method. Journal of Applied Statistics, 40(2): 
266-281. DOI: 10.1080/02664763.2012.740626.}
\item{Feng, Y., Gries. T, and Fritz, M. (2020). Data-driven local polynomial 
for the trend and its derivatives in economic time series. Journal of 
Nonparametric Statistics, 32(2): 510-533. DOI: 10.1080/10485252.2020.1759598.}
}
}
\author{
\itemize{
\item Dominik Schulz (Research Assistant) (Department of Economics, Paderborn
University), \cr
Author and Package Creator
\item Yuanhua Feng (Department of Economics, Paderborn
University), \cr
Author
}
}
