% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/d.ends.R
\name{d.ends}
\alias{d.ends}
\title{Extreme (both high and low) values are desirable}
\usage{
d.ends(x, cut1, cut2, cut3, cut4, des.min = 0, des.max = 1, scale = 1)
}
\arguments{
\item{x}{Vector of numeric or integer values.}

\item{cut1,cut2,cut3,cut4}{Values of the original data that define where the
desirability function changes.}

\item{des.min,des.max}{Minimum and maximum desirability values. Defaults to
zero and one, respectively.}

\item{scale}{Controls how steeply the function increases or decreases.}
}
\value{
Numeric vector of desirability values.
}
\description{
Maps a numeric variable to a 0-1 scale such that values at the
ends of the distribution are desirable.
}
\details{
Values less than \code{cut1} and greater than \code{cut4} will have
a high desirability. Values between \code{cut2} and \code{cut3} will have a
low desirability. Values between \code{cut1} and \code{cut2} and between
\code{cut3} and \code{cut4} will have intermediate values. This function is
useful when the data represent differences between groups; for example, log2
fold-changes in gene expression. In this case, both high an low values are of
interest.
}
\examples{
set.seed(1)
x <- rnorm(1000, mean=100, sd =5) # generate data
d <- d.ends(x, cut1=90, cut2=95, cut3=105, cut4=110, scale=1)

# plot data
hist(x, breaks=30)
# add line
des.line(x, "d.ends", des.args=c(cut1=90, cut2=95, cut3=105,
cut4=110, scale=1))

hist(x, breaks=30)
des.line(x, "d.ends", des.args=c(cut1=90, cut2=95, cut3=105,
cut4=110, des.min=0.1, des.max=0.95, scale=1.5))
}
\seealso{
\code{\link{d.central}}
}

