% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{design.contrasts}
\alias{design.contrasts}
\alias{contrast.names}
\title{Retrieve contrast codes for a design}
\usage{
design.contrasts(design, factors = names(fixed.factors(design)),
  contrasts = NULL, expand = TRUE, rename_contrasts = "\%1$s\%2$s",
  intercept = FALSE, interactions = FALSE,
  include_random_levels = FALSE)

contrast.names(design, ranfac = NULL, as_symbols = FALSE, ...)
}
\arguments{
\item{design}{A design object}

\item{factors}{Which fixed factors to include in the output}

\item{contrasts}{Contrasts to use for each categorical factor. Should be a list named after the fixed effects and containing contrast matrices, such as the ones generated by the standard contrast functions. If NULL or the fixed factor is not found in the list, default contrasts are used (typically, treatment contrasts).}

\item{expand}{If TRUE, a design matrix is returned. If FALSE, all factors (and interactions) with their respective levels are returned.}

\item{rename_contrasts}{This is the pattern after which columns in the design matrix are named. By default, this is a direct concatenation of factor name and contrast name.}

\item{intercept}{If TRUE, an intercept is added to the matrix. Its value is 1 for all observations.}

\item{interactions}{If TRUE, interactions of fixed factors are included.}

\item{include_random_levels}{If TRUE, levels of random factors are included in the matrix.}

\item{ranfac}{Return random-effects contrast names for a given random factor. If NULL, return fixed-effects contrast names.}

\item{as_symbols}{Return contrast names as symbols rather than strings (character vectors).}

\item{...}{Arguments to pass on to design.contrasts()}
}
\value{
A design matrix (if expand==TRUE, default) or a list of factor levels (if expand==FALSE) for design.contrasts or contrast names for contrast.names.
}
\description{
This function can be used to retrieve contrast codes based on experimental codes / planned observations.

Use this function to retrieve the names for contrasts in an experimental design, such as used by lm, lmer and many other regression models.
}
\section{Functions}{
\itemize{
\item \code{contrast.names}: Retrieve contrast names for a design
}}

\examples{


des <- fixed.factor("Factor1", c("1A","1B")) +
       fixed.factor("Factor2", c("2A","2B")) +
       random.factor("Subject", c("Factor1"))

              
design.contrasts(des)

contrast.names(des)

stopifnot(contrast.names(des) == c("Factor11B", "Factor22B"))

contrast.names(des, as_symbols = TRUE)

design.contrasts(des, contrasts = list(Factor2 = contr.sum))

contrast.names(des, contrasts = list(Factor2 = contr.sum))

}
