% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funktionen.R
\name{readExternalRuns}
\alias{readExternalRuns}
\title{Read runs from external files}
\usage{
readExternalRuns(inputFile = NULL, program = c("plink", "BCFtools",
  "detectRUNS"))
}
\arguments{
\item{inputFile}{name of (path to) external file}

\item{program}{source program that produced the ROH file (one of \code{detectRUNS},
\code{Plink}, \code{BCFtools})}
}
\value{
dataframe in the correct format to be used with plots and statistics functions from \code{detectRUNS}
}
\description{
Function to read in, from external files, the output of software for ROH:
\enumerate{
\item \code{detectRUNS}: output saved out to a file (e.g. write.table)
\item \code{Plink}: output from the \code{--homozyg} option (\code{.hom} files)
\item \code{BCFtools}: output from the \code{roh} option
}
}
\examples{
# getting map and ped paths
\dontrun{
genotypeFile <- system.file("extdata", "Kijas2016_Sheep_subset.ped", package = "detectRUNS")
mapFile <- system.file("extdata", "Kijas2016_Sheep_subset.map", package = "detectRUNS")

# calculating runs of Homozygosity
runs <- slidingRUNS.run(genotypeFile, mapFile, windowSize = 15, threshold = 0.1,  minSNP = 15,
ROHet = FALSE,  maxMissRun = 1, maxMissWindow = 1,  minLengthBps = 100000,  minDensity = 1/10000)

write.table(x= runs,file = 'RunsFileTest.txt', quote=F, row.names = F)
newData=readRunsFromFile(runsFile = 'RunsFileTest.txt', program = 'detectRUNS')
}

}
