% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_tau.R
\name{best_tau}
\alias{best_tau}
\title{Find the best tau parameter for exponential smoothing detrending.}
\usage{
best_tau(img, cutoff = 0.05, parallel = FALSE, purpose = c("FCS",
  "FFS"))
}
\arguments{
\item{img}{A 4-dimensional array in the style of an
\link[ijtiff:ijtiff_img]{ijtiff_img} (indexed by \code{img[y, x, channel, frame]})
or a 3-dimensional array which is a single channel of an
\link[ijtiff:ijtiff_img]{ijtiff_img} (indexed by \code{img[y, x, frame]}).}

\item{cutoff}{In \emph{exponential filtering} detrending, for the weighted
average, every point gets a weight. This can slow down the computation
massively. However, many of the weights will be approximately zero. With
cutoff, we say that any point with weight less than or equal to \code{cutoff}
times the maximum weight may be ignored; so with \code{cutoff = 0.05}, any
weight less than 5\% of the maximum weight may be ignored. The default
value of this parameter is sensible and its value should not be set to
anything else without good reason.}

\item{parallel}{Would you like to use multiple cores to speed up this
function? If so, set the number of cores here, or to use all available
cores, use \code{parallel = TRUE}.}

\item{purpose}{What type of calculation do you intend to perform on the
detrended image? If it is an FFS (fluorescence fluctuation spectroscopy)
calculation (like number and brightness), choose 'FFS'. If it is an FCS
(fluorescence correlation spectroscopy) calculation (like cross-correlated
number and brightness or autocorrelation), choose 'FCS'. The difference is
that if \code{purpose} is 'FFS', the time series is corrected for non-stationary
mean and variance, whereas if \code{purpose} is 'FCS', the time series is
corrected for non-stationary mean only. `purpose`` is not required for
\emph{Robin Hood} detrending.}
}
\value{
If no detrend is necessary, this function returns \code{NA}. If a detrend
is required, this function returns a natural number which is the ideal
\code{tau} parameter for exponential smoothing detrending. If there are multiple
channels, the function returns a vector, one \code{tau} parameter for each
channel.
}
\description{
Use Nolan's algorithm to find the ideal tau parameter for exponential
smoothing detrending.
}
\examples{
\dontrun{
## These examples are not run on CRAN because they take too long.
## You can still try them for yourself.
img <- ijtiff::read_tif(system.file('extdata', 'bleached.tif',
                                    package = 'detrendr'))[, , 1, ]
best_tau(img, parallel = 2)
}

}
\references{
Rory Nolan, Luis A. J. Alvarez, Jonathan Elegheert, Maro
Iliopoulou, G. Maria Jakobsdottir, Marina Rodriguez-Muñoz, A. Radu
Aricescu, Sergi Padilla-Parra; nandb—number and brightness in R with a
novel automatic detrending algorithm, Bioinformatics,
https://doi.org/10.1093/bioinformatics/btx434.
}
