% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devRate_phenoBDD.R
\name{devRateIBMparam}
\alias{devRateIBMparam}
\title{Forecast ectotherm phenology as a function of temperature and development
rate models using known parameters}
\usage{
devRateIBMparam(
  tempTS,
  timeStepTS,
  eq,
  myParam,
  numInd = 10,
  stocha,
  timeLayEggs = 1
)
}
\arguments{
\item{tempTS}{The temperature time series (a vector).}

\item{timeStepTS}{The time step of the temperature time series (a numeric
with 1 = one day).}

\item{eq}{The name of the equation (e.g., lactin2_95).}

\item{myParam}{The known parameters for the equation (a list of list for
each life stage).}

\item{numInd}{The number of individuals for the simulation (an integer).}

\item{stocha}{The standard deviation of a Normal distribution centered on
development rate to create stochasticity among individuals (a numeric).}

\item{timeLayEggs}{The delay between emergence of adults and the time where
females lay eggs in time steps (a numeric).}
}
\value{
A list with three elements: the table of phenology for each individual,
   the models used (nls objects), and the time series for temperature.
}
\description{
Forecast ectotherm phenology as a function of temperature and development
rate models using known parameters
}
\details{
Please note that this function is experimental and only works for
  the briere2_99 equation.
}
\examples{
# with only one life stage
forecastX <- devRateIBMparam(
  tempTS = rnorm(n = 20, mean = 20, sd = 1),
  timeStepTS = 10,
  eq = briere2_99,
  myParam = list(
    list(
      aa = 0.0002,
      Tmin = 10,
      Tmax = 36.1,
      bb = 2.84)
  ),
  numInd = 10,
  stocha = 0.015,
  timeLayEggs = 1
)
# with two life stages
forecastXX <- devRateIBMparam(
  tempTS = rnorm(n = 20, mean = 20, sd = 1),
  timeStepTS = 10,
  eq = briere2_99,
  myParam = list(
    lifeStage01 = list(
      aa = 0.0002,
      Tmin = 10,
      Tmax = 36.1,
      bb = 2.84),
    lifeStage02 = list(
      aa = 0.0004,
      Tmin = 8,
      Tmax = 35,
      bb = 2.8)
  ),
  numInd = 10,
  stocha = 0.015,
  timeLayEggs = 1
)
}
