% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexter.R
\name{add_booklet}
\alias{add_booklet}
\title{Add a booklet to a project}
\usage{
add_booklet(db, x, booklet_id)
}
\arguments{
\item{db}{A handle to the database, i.e. the output of \code{start_new_project}
or \code{open_project}}

\item{x}{A data frame containing the responses and, possibly, some additional
person characteristics. See details.}

\item{booklet_id}{A (short) string identifying the test form (booklet)}
}
\value{
A list of: \item{items}{The names of the columns in \code{x} that were
treated as items}
\item{covariates}{The names of the columns in \code{x} that were
treated as person covariates}
\item{not_listed}{A data frame of all responses that will be treated as missing}
}
\description{
Adds item response data for a test form (a.k.a. booklet)
}
\details{
It is common practice to keep data in rectangular tables: data frames
or foreign software like Excel, SPSS, etc. This function is provided to input
data in that form, one booklet at a time. The starting point is a data frame,
and getting the data frame into R is left to the user. We have found package
\code{readxl} to be very good at reading Excel sheets, and \code{haven} quite
efficient with SPSS files.

This package is not doing any person management. We assume that each person
has responded to only one test form, once, and we don't check for any
duplicates. If users supply a sound person ID of their own, they will be able to
link ability measures with results of the same person on a different test, but
this is their own responsibility. Also, data from two-stage tests (a routing test
and a follow-up test) should be matched by the user before entered.

Any variable whose name has an exact match in the scoring rules input with
function \code{start_new_project} will be treated as an item; any other
variables will be treated as person covariates. Any responses to an item that
do not have an exact match in the scoring rules will be treated as missing, and
ultimately given the lowest score of 0. To score missing data differently, or simply
abide to good style, the user can include explicit entries for missing value
indicators in the scoring rules.
}
\author{
Ivailo Partchev
}

