% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexter.R
\name{add_item_properties}
\alias{add_item_properties}
\title{Add item properties to a project}
\usage{
add_item_properties(db, item_properties, overwrite = FALSE)
}
\arguments{
\item{db}{A handle to the database, e.g. the output of \code{start_new_project}
or \code{open_project}}

\item{item_properties}{A data frame containing the item properties. See details.}

\item{overwrite}{Whether overwrite is permitted (default=FALSE)}
}
\value{
A list of: \item{unknown_items}{Item IDs for any items that were provided
in the data frame but could not be found in the data base}
\item{items_unaccounted_for}{Item IDs for any items that exist in the data base
but were not given properties in the data frame}
}
\description{
Adds item properties to an existing database
}
\details{
When entering response data in the form of a rectangular person x item
table, it is easy to provide person properties but practically impossible
to provide item properties. This function provides a possibility to do so.
The order of the rows and columns in the data frame is not important but
(i) there must be a column called exactly \code{item} or \code{item_id} containing the item IDs
exactly as entered before, and (ii) all items in the data frame must be known
to the data base and all items in the data base must be given properties --
otherwise, there will be a warning message, and nothing else will be done.
If all is well, the data frame will be added to the project database, and any variables in 
it may be used in analyses involving item properties.
}
\examples{
\dontrun{
db = start_new_project(verbAggrRules, "verbAggression.db", 
  covariates=list(gender="<unknown>"))
head(verbAggrProperties)
add_item_properties(db, verbAggrProperties)
show_item_properties(db)
}


}
\seealso{
\code{\link{fit_domains}}, \code{\link{profile_plot}} for
 possible uses of item_properties
}
