% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexter.R
\name{keys_to_rules}
\alias{keys_to_rules}
\title{Derive scoring rules from keys}
\usage{
keys_to_rules(keys, include_NA_rule = FALSE)
}
\arguments{
\item{keys}{A data frame containing columns \code{item_id}, \code{nOptions}, and
\code{key} (the spelling is important). See details.}

\item{include_NA_rule}{whether to add an option 'NA' (which is scored 0) to each item}
}
\value{
A data frame that can be used as input to \code{start_new_project}
}
\description{
For multiple choice items that will be scored as 0/1, derive the
scoring rules from the keys to the correct responses
}
\details{
This function might be useful in setting up the scoring rules when all items
are multiple-choice and scored as 0/1. (Hint: Because the order in which the
scoring rules is not important, one can use the function to generate rules for
many MC items and then append per hand the rules for a few complex items.)

The input data frame must contain the exact name of each item, the number
of options, and the key. If the keys are all integers, it will be assumed that
responses are coded as 1 through nOptions. If they are all uppercase letters,
it is assumed that responses are coded as A,B,C,... All other cases result
in an error.
}
