% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tia.R
\name{tia_tables}
\alias{tia_tables}
\title{Simple test-item analysis}
\usage{
tia_tables(dataSrc, predicate = NULL, type = c("raw", "averaged",
  "compared"))
}
\arguments{
\item{dataSrc}{a connection to a dexter database, a matrix, or a data.frame with columns: person_id, item_id, item_score}

\item{predicate}{An optional expression to subset data, if NULL all data is used}

\item{type}{How to present the item level statistics: \code{raw} for each test booklet 
separately, \code{averaged} averaged over the test booklet in which the item is included,
with the number of persons as weights, or \code{compared}, in which case the pvalues, 
correlations with the sum score (rit), and correlations with the rest score (rit) are 
shown in separate tables and compared across booklets}
}
\value{
A list containing:
\item{testStats}{a data.frame of statistics at test level} 
\item{itemStats}{a data.frame (or list if type='compared') of statistics at item level}
}
\description{
Show simple Classical Test Analysis statistics
at item and test level
}
