% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.enorm}
\alias{plot.enorm}
\title{Plot for the extended nominal Response model}
\usage{
\method{plot}{enorm}(
  x,
  item_id = NULL,
  dataSrc = NULL,
  predicate = NULL,
  nbins = 5,
  ci = 0.95,
  add = FALSE,
  col = "black",
  col.model = "grey80",
  ...
)
}
\arguments{
\item{x}{object produced by fit_enorm}

\item{item_id}{which item to plot, if NULL, one plot for each item is made}

\item{dataSrc}{data source, see details}

\item{predicate}{an expression to subset data in dataSrc}

\item{nbins}{number of ability groups}

\item{ci}{confidence interval for the error bars, between 0 and 1. Use 0 to suppress the error bars.
Default = 0.95 for a 95\% confidence interval}

\item{add}{logical; if TRUE add to an already existing plot}

\item{col}{color for the observed score average}

\item{col.model}{color for the expected score based on the model}

\item{...}{further arguments to plot}
}
\value{
Silently, a data.frame with observed and expected values possibly useful to create a numerical fit measure.
}
\description{
The plot shows 'fit' by comparing the expected score based on the model (grey line)
with the average scores based on the data (black line with dots) for groups of students
with similar estimated ability.
}
\details{
The standard plot shows the fit against the sample on which the parameters were fitted. If
dataSrc is provided, the fit is shown against the observed data in dataSrc. This may be useful 
for plotting the fit in different subgroups as a visual test for item level DIF. The confidence 
intervals denote the uncertainty about the predicted pvalues within the ability groups for the 
sample size in dataSrc (if not NULL) or the original data on which the model was fit.
}
\examples{
\dontshow{ RcppArmadillo::armadillo_throttle_cores(1)}
db = start_new_project(verbAggrRules, ":memory:", 
  person_properties=list(gender=""))

add_booklet(db, verbAggrData, "agg")

f = fit_enorm(db)

plot(f, items="S1DoShout")

# side by side for two different groups
# (it is also possible to show two lines in the same plot 
# by specifying add=TRUE as an argument in the second plot)

par(mfrow=c(1,2))

plot(f,items="S1WantCurse",dataSrc=db, predicate = gender=='Male', 
  main='men - $item_id')

plot(f,items="S1WantCurse",dataSrc=db, predicate = gender=='Female', 
  main='women - $item_id')

close_project(db)
\dontshow{ RcppArmadillo::armadillo_reset_cores()}

}
