% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{methods.dfidx}
\alias{methods.dfidx}
\alias{[.dfidx}
\alias{as.data.frame.dfidx}
\alias{print.dfidx}
\alias{vec_ptype_abbr.vecidx}
\alias{format.vecidx}
\alias{pillar_shaft.vecidx}
\alias{head.dfidx}
\alias{[[.dfidx}
\alias{$.dfidx}
\alias{$<-.dfidx}
\alias{[[<-.dfidx}
\alias{print.xseries}
\alias{print.idx}
\alias{mean.dfidx}
\title{Methods for dfidx}
\usage{
\method{[}{dfidx}(x, i, j, drop)

\method{as.data.frame}{dfidx}(x, row.names = NULL, optional = FALSE, ...)

\method{print}{dfidx}(x, ..., n = NULL)

\method{vec_ptype_abbr}{vecidx}(x, ..., prefix_named, suffix_shape)

\method{format}{vecidx}(x, ...)

\method{pillar_shaft}{vecidx}(x, ...)

\method{head}{dfidx}(x, n = 10L, ...)

\method{[[}{dfidx}(x, y)

\method{$}{dfidx}(x, y)

\method{$}{dfidx}(object, y) <- value

\method{[[}{dfidx}(object, y) <- value

\method{print}{xseries}(x, ..., n = 10L)

\method{print}{idx}(x, ..., n = 10L)

\method{mean}{dfidx}(x, ...)
}
\arguments{
\item{x, object}{a \code{dfidx} object}

\item{i}{the row index}

\item{j}{the column index}

\item{drop}{if \code{TRUE} a vector is returned if the result is a one
column \code{data.frame}}

\item{row.names, optional}{arguments of the generic \code{as.data.frame}
method, not used}

\item{...}{further arguments}

\item{n}{the number of rows for the print method}

\item{prefix_named, suffix_shape}{see \link[vctrs:vec_ptype_full]{vctrs::vec_ptype_abbr}}

\item{y}{the name or the position of the series one wishes to
extract}

\item{value}{the value for the replacement method}
}
\value{
\code{as.data.frame} and \code{mean} return a \code{data.frame}, \code{[[} and
\code{$} a vector, \code{[} either a \code{dfidx} or a vector, \verb{$<-}
and \verb{[[<-} modify the values of an existing column or create a
new column of a \code{dfidx} object, \code{print} is called for its side
effect
}
\description{
A \code{dfidx} is a \code{data.frame} with a "sticky" data.frame column
which contains the indexes. Specific methods of functions that
extract lines and/or columns of a \code{data.frame} are provided.
}
\examples{
mn <- dfidx(munnell)
# extract a series (returns as a xseries object)
mn$gsp
# or
mn[["gsp"]]
# extract a subset of series (returns as a dfidx object)
mn[c("gsp", "unemp")]
# extract a subset of rows and columns
mn[mn$unemp > 10, c("utilities", "water")]
# dfidx, idx and xseries have print methods as (like tibbles), a n
# argument
print(mn, n = 3)
print(idx(mn), n = 3)
print(mn$gsp, n = 3)
# a dfidx object can be coerced to a data.frame
head(as.data.frame(mn))
}
\author{
Yves Croissant
}
