% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{defoliate_trees}
\alias{defoliate_trees}
\title{Identify defoliation events in host trees}
\usage{
defoliate_trees(host_tree, nonhost_chron, duration_years = 8,
  max_reduction = -1.28, bridge_events = FALSE,
  series_end_event = FALSE, list_output = FALSE)
}
\arguments{
\item{host_tree}{A \code{dplR::rwl} object containing the tree-level growth series
for all host trees to be compared to the non-host chronology.}

\item{nonhost_chron}{A \code{dplR::rwl} object containing a single non-host
chronology.}

\item{duration_years}{The minimum length of time in which the tree is
considered to be in defoliation.}

\item{max_reduction}{The minimum value of \code{ngsi} required to be considered a
defoliation event. If a sequence of negative ngsi values does not reach
this threshold, the potential event is rejected. Defaults to -1.28.}

\item{bridge_events}{Binary, defaults to \code{FALSE}. This option allows for
successive events that are separated by a single year to be bridged and
become one event. It should be used cautiously and closely evaluated to
ensure the likelihood that the two (or more) events are actually one long
event.}

\item{series_end_event}{Binary, defaults to \code{FALSE}. This option allows the
user to identify an event occurring at the time of sampling as a
defoliation event, regardless of duration. Including it will help to
quantify periodicity and extent of an outbreak. This should only be used if
the user has direct knowledge of an ongoing defoliation event when the
trees were sampled.}

\item{list_output}{Defaults to \code{FALSE}. This option is to output a long list
object containing a separate data.frame for each series in \code{host_tree} that
includes the input series and the \code{nonhost_chron}, the corrected series, and
the character string identifying the defoliation events.}
}
\value{
By default this returns a long-form data frame of tree-level growth
suppression indices and identified defoliation events. If \code{list_output = TRUE}, it returns a list object with each element containing a data.frame
rwl object of the host and non-host series, plus the outputs from \code{\link[=gsi]{gsi()}}.
The list object is useful for assessing the effects of running \code{\link[=gsi]{gsi()}} on
the host and nonhost data.
}
\description{
\code{\link[=defoliate_trees]{defoliate_trees()}} is the starting point for most analyses of insect
defoliation signals preserved in the growth patterns of trees. It requires
individual-tree standardized measurements from potential host trees and a
tree-ring chronology from a nearby non-host species. First, \code{\link[=defoliate_trees]{defoliate_trees()}}
combines these tree-ring indices by calling \code{\link[=gsi]{gsi()}} to perform a
"correction" of the host-tree indices to remove the climatic influences on
tree growth as represented by the non-host chronology. This should isolate a
disturbance-related signal. Second, \code{\link[=defoliate_trees]{defoliate_trees()}}, runs \code{\link[=id_defoliation]{id_defoliation()}}, which completes a
runs analyses to evaluate sequences of negetive departures in the host tree growth series (\code{ngsi})
for potential defoliation events.
}
\note{
Other functions in \code{dfoliatR}, like \code{\link[=outbreak]{outbreak()}} and \code{\link[=plot_defol]{plot_defol()}},
require a long-form data frame identifiable as a \code{\link[=defol]{defol()}} object. Selecting
\code{list_output = TRUE} will trigger errors in running other functions.
}
\examples{
# Load host and non-host data
data("dmj_h") # Host trees
data("dmj_nh") # Non-host chronology

dmj_defol <- defoliate_trees(dmj_h, dmj_nh)


}
