% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{obr}
\alias{obr}
\title{Constructor for an \code{obr} object.}
\usage{
obr(
  year,
  samp_depth,
  num_defol,
  perc_defol,
  num_max_defol,
  perc_max_defol,
  mean_gsi,
  mean_ngsi,
  outbreak_status
)
}
\arguments{
\item{year}{An n-length numeric vector of observed years.}

\item{samp_depth}{An n-length numeric vector of the number of trees.}

\item{num_defol}{An n-length numeric vector of the number of trees
experiencing defoliation.}

\item{perc_defol}{An n-length numeric vector of the percent of trees
experiencing defoliation.}

\item{num_max_defol}{An n-length numeric vector of the number of trees
experiencing their maximum level of defoliation (i.e., their most extreme
negative growth departure).}

\item{perc_max_defol}{An n-length numeric vector of the percent of trees
experiencing their maximum level of defoliation (i.e., their most extreme
negative growth departure).}

\item{mean_gsi}{An n-length numeric vector of the average growth suppression
index across all observed trees.}

\item{mean_ngsi}{An n-length numeric vector of the average normalized
(scaled) growth suppression index.}

\item{outbreak_status}{An n-length factor or character vector that identified
whether that year surpasses the designated thresholds for an "outbreak
event". Threshold criteria are provided in \code{\link[=outbreak]{outbreak()}}.}
}
\value{
An \code{obr} object with columns matching the input variables.
}
\description{
Constructor for an \code{obr} object.
}
