\name{sim.data}
\alias{sim.data}

\title{
Generate and store PK and toxicity data.
}

\description{
This function can be used to generate and store PK and toxicity data in order to be used for simulation according to the dose-finding model.
}

\usage{
sim.data(PKparameters, omegaIIV, omegaAlpha, sigma, doses, limitTox, 
         timeSampling, N, TR, seed=190591)
}

\arguments{
  \item{PKparameters}{
Subject's pharmacokinetic's (PK) parameters from the population distributions defined by the population mean. 
}
\item{omegaIIV}{
The inter-individual variability for the clearance and the volume of distribution; possible values may be 70\% or 30\% in different simulated data.
}
  \item{omegaAlpha}{
The patient's sensitivity parameter. 
}
  \item{sigma}{
The additive or proportional error.
}
  \item{doses}{
A vector with the doses panel. 
}
  \item{limitTox}{
The toxicity threshold.
}
  \item{timeSampling}{
The sampling time points.
}
  \item{N}{
The total sample size per trial.  
}
  \item{TR}{
The total number of simulated datasets.  
}
  \item{seed}{
The seed of the random number generator that is used at the beginning of each trial; defaults to 190591.   
}
}

\value{
An object of class "scen" is returned, consisting of simulated PK and toxicity data. Objects generated by sim.data contain at least the following components:

\item{PKparameters}{Subject's pharmacokinetic's (PK) parameters from the population distributions defined by the population mean.}
\item{nPK}{The length of the time points.}
\item{time}{The sampling time points.}
\item{idtr}{The id number of the corresponding simulated dataset.}
\item{N}{The total sample size per trial.}
\item{doses}{A vector with the doses panel.}
\item{preal}{The prior toxicity probabilities.}
\item{limitTox}{The tocixity threshold.}
\item{omegaIIV}{The inter-individual variability for the clearance and the volume of distribution.}
\item{omegaAlpha}{The patient's sensitivity parameter.}
\item{conc}{The concentration computed at the PK population values.}
\item{concPred}{The concentration values with proportional errors for each patient at each dose.}
\item{tox}{The toxicity outcome.}
\item{parameters}{The simulated PK parameters of each patient.}
\item{alphaAUC}{A vector with the computed AUC values of each patient.}
\item{tab}{A summary matrix containing the sampling time points at the first row followed by concPred, parameters and alphaAUC. 
           It used by the simulation function \code{\link{nsim}}.}
}

\references{
Ursino, M., et al, (2017) Dose-finding methods for Phase I clinical trials using pharmacokinetics in small populations, Biometrical Journal, <doi:10.1002/bimj.201600084>.

Toumazi, A., et al, (2018) dfpk: An R-package for Bayesian dose-finding designs using pharmacokinetics (PK) for phase I clinical trials, Computer Methods and Programs in Biomedicine, <doi:10.1016/j.cmpb.2018.01.023>.
}

\author{Artemis Toumazi \email{artemis.toumazi@gmail.com}, 
        Moreno Ursino \email{moreno.ursino@inserm.fr},
        Sarah Zohar \email{sarah.zohar@inserm.fr}
        }
        
\seealso{
\code{\link{nsim}}
}

\examples{
TR = 10
N = 30
limitTox <- 10.96                                                
PKparameters <- c(2,10,100)       # PK parameters ka,CL,V
omegaIIV <- 0.7                   # Inter-individual
omegaAlpha <- 0                    
doses <- c(12.59972,34.65492,44.69007,60.80685,83.68946,100.37111)
timeSampling <- seq(0,24,length.out=48)    
sigma <- rep(0.2,length(timeSampling))  # sigma: Additive or proportional error

gen.scen <- sim.data(PKparameters,omegaIIV,omegaAlpha,sigma,doses,
                     limitTox,timeSampling, N, TR, seed=190591) 
gen.scen[[1]]     # returns the first simulated dataset. 


#### Graphical representation of the first simulated data
# plot(gen.scen[[1]])

}


