% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_reference_words.R
\name{get_reference_words}
\alias{get_reference_words}
\title{Retrieve Reference Words Count and Relative Frequency}
\usage{
get_reference_words(
  doctype = "digibok",
  from_year = 1990,
  to_year = 2000,
  words = NULL
)
}
\arguments{
\item{doctype}{A character string indicating the document type. One of "digibok", "digavis", or "digitidsskrift".}

\item{from_year}{A numeric value indicating the starting year of the range.}

\item{to_year}{A numeric value indicating the ending year of the range.}

\item{words}{A vector of words for which the count and relative frequency will be retrieved.}
}
\value{
A list containing the count and relative frequency of the specified words within the given year range and document type.
}
\description{
This function obtains the count and relative frequency of a vector of words within a year range for specified document types.
}
\examples{
doctype <- "digibok"
from_year <- 1900
to_year <- 2000
words <- c("og", "eller", "men")
result <- get_reference_words(doctype, from_year, to_year, words)
}
