% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regL1.R
\name{summary.regL1}
\alias{summary.regL1}
\title{Summary methods for L1 Regression}
\usage{
\method{summary}{regL1}(
  object,
  se = NULL,
  covariance = FALSE,
  hs = TRUE,
  U = NULL,
  gamma = 0.7,
  ...
)
}
\arguments{
\item{object}{Object returned from regL1 representing the fit of the L1 model.}

\item{se}{specifies the method used to compute standard standard errors. There are currently seven available methods: "rank", "iid", "nid", "ker", "boot", "BLB", "conquer" and "extreme".}

\item{covariance}{logical flag to indicate whether the full covariance matrix of the estimated parameters should be returned.}

\item{hs}{Use Hall Sheather bandwidth for sparsity estimation If false revert to Bofinger bandwidth.}

\item{U}{Resampling indices or gradient evaluations used for bootstrap, see \code{\link{summary.rq}} and \code{\link{boot.rq}} for more details.}

\item{gamma}{parameter controlling the effective sample size of the'bag of little bootstrap samples that will be b = n^gamma where n is the sample size of the original model.}

\item{...}{Optional arguments. See \code{\link{summary.rq}} for more details.}
}
\value{
No return value, called for side effects.
}
\description{
Returns a summary list for a L1 regression fit. A null value will be returned if printing is invoked
}
\seealso{
\code{\link{regL1}} for fitting linear L1 models.
\code{\link{summary.rq}} summary methods for Quantile Regression.
}
