% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.diagstats.R
\name{print.diagstats}
\alias{print.diagstats}
\title{Print method for diagstats objects}
\usage{
\method{print}{diagstats}(x, sensspec = TRUE, predicted = TRUE, density = FALSE, digits = 3, ...)
}
\arguments{
\item{x}{An object of class \code{diagmeta}.}

\item{sensspec}{A logical indicating whether sensitivities and
specificies should be printed.}

\item{predicted}{A logical indicating whether predicted values
should be printed.}

\item{density}{A logical indicating whether values of the
model-based density functions should be printed.}

\item{digits}{Number of significant digits for printing.}

\item{\dots}{Additional arguments.}
}
\description{
Print method for objects of class \code{diagstats}.
}
\examples{
# FENO dataset
#
data(Schneider2017)

diag1 <- diagmeta(tpos, fpos, tneg, fneg, cutpoint,
                  studlab = paste(author, year, group),
                  data = Schneider2017, 
                  log.cutoff = TRUE)

# Values for prevalence 10\% at cutoffs 25 and 50
#
ds1 <- diagstats(diag1, c(25, 50), 0.10)
ds1
print(ds1, predicted = FALSE)

}
\seealso{
\code{\link{diagstats}} \code{\link{diagmeta}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{print}
