% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalize.R
\name{finalize}
\alias{finalize}
\alias{finalize.list}
\alias{finalize.param}
\alias{finalize.parameters}
\alias{finalize.logical}
\alias{finalize.default}
\alias{get_p}
\alias{get_log_p}
\alias{get_n_frac}
\alias{get_n_frac_range}
\alias{get_n}
\alias{get_rbf_range}
\alias{get_batch_sizes}
\title{Functions to finalize data-specific parameter ranges}
\usage{
finalize(object, ...)

\method{finalize}{list}(object, x, force = TRUE, ...)

\method{finalize}{param}(object, x, force = TRUE, ...)

\method{finalize}{parameters}(object, x, force = TRUE, ...)

\method{finalize}{logical}(object, x, force = TRUE, ...)

\method{finalize}{default}(object, x, force = TRUE, ...)

get_p(object, x, log_vals = FALSE, ...)

get_log_p(object, x, ...)

get_n_frac(object, x, log_vals = FALSE, frac = 1/3, ...)

get_n_frac_range(object, x, log_vals = FALSE, frac = c(1/10, 5/10), ...)

get_n(object, x, log_vals = FALSE, ...)

get_rbf_range(object, x, seed = sample.int(10^5, 1), ...)

get_batch_sizes(object, x, frac = c(1/10, 1/3), ...)
}
\arguments{
\item{object}{A \code{param} object or a list of \code{param} objects.}

\item{...}{Other arguments to pass to the underlying parameter
finalizer functions. For example, for \code{get_rbf_range()}, the dots are passed
along to \code{\link[kernlab:sigest]{kernlab::sigest()}}.}

\item{x}{The predictor data. In some cases (see below) this should only
include numeric data.}

\item{force}{A single logical that indicates that even if the parameter
object is complete, should it update the ranges anyway?}

\item{log_vals}{A logical: should the ranges be set on the log10 scale?}

\item{frac}{A double for the fraction of the data to be used for the upper
bound. For \code{get_n_frac_range()} and \code{get_batch_sizes()}, a vector of two
fractional values are required.}

\item{seed}{An integer to control the randomness of the calculations.}
}
\value{
An updated \code{param} object or a list of updated \code{param} objects depending
on what is provided in \code{object}.
}
\description{
These functions take a parameter object and modify the unknown parts of
\code{ranges} based on a data set and simple heuristics.
}
\details{
\code{finalize()} runs the embedded finalizer function contained in the \code{param}
object (\code{object$finalize}) and returns the updated version. The finalization
function is one of the \verb{get_*()} helpers.

The \verb{get_*()} helper functions are designed to be used with the pipe
and update the parameter object in-place.

\code{get_p()} and \code{get_log_p()} set the upper value of the range to be
the number of columns in the data (on the natural and
log10 scale, respectively).

\code{get_n()} and \code{get_n_frac()} set the upper value to be the number of
rows in the data or a fraction of the total number of rows.

\code{get_rbf_range()} sets both bounds based on the heuristic defined in
\code{\link[kernlab:sigest]{kernlab::sigest()}}. It requires that all columns in \code{x} be numeric.
}
\examples{
library(dplyr)
car_pred <- select(mtcars, -mpg)

# Needs an upper bound
mtry()
finalize(mtry(), car_pred)

# Nothing to do here since no unknowns
penalty()
finalize(penalty(), car_pred)

library(kernlab)
library(tibble)
library(purrr)

params <-
  tribble(
     ~parameter,   ~object,
         "mtry",      mtry(),
    "num_terms", num_terms(),
    "rbf_sigma", rbf_sigma()
  )
params

# Note that `rbf_sigma()` has a default range that does not need to be
# finalized but will be changed if used in the function:
complete_params <-
  params \%>\%
  mutate(object = map(object, finalize, car_pred))
complete_params

params \%>\% dplyr::filter(parameter == "rbf_sigma") \%>\% pull(object)
complete_params \%>\% dplyr::filter(parameter == "rbf_sigma") \%>\% pull(object)

}
