
<!-- README.md is generated from README.Rmd. Please edit that file -->

# dials <a href="https://dials.tidymodels.org/"><img src="man/figures/logo.png" align="right" height="138" alt="a stylized black dial on a beige background" /></a>

<!-- badges: start -->

[![R-CMD-check](https://github.com/tidymodels/dials/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/tidymodels/dials/actions/workflows/R-CMD-check.yaml)
[![Codecov test
coverage](https://codecov.io/gh/tidymodels/dials/branch/main/graph/badge.svg)](https://app.codecov.io/gh/tidymodels/dials?branch=main)
[![CRAN_Status_Badge](http://www.r-pkg.org/badges/version/dials)](https://CRAN.R-project.org/package=dials)
[![Downloads](http://cranlogs.r-pkg.org/badges/dials)](https://CRAN.R-project.org/package=dials)
[![lifecycle](https://img.shields.io/badge/lifecycle-stable-brightgreen.svg)](https://lifecycle.r-lib.org/articles/stages.html)
[![R-CMD-check-hard](https://github.com/tidymodels/dials/actions/workflows/R-CMD-check-hard.yaml/badge.svg)](https://github.com/tidymodels/dials/actions/workflows/R-CMD-check-hard.yaml)
<!-- badges: end -->

## Overview

This package contains *infrastructure* to create and manage values of
tuning parameters for the tidymodels packages. If you are looking for
*how to* tune parameters in tidymodels, please look at the
[tune](https://tune.tidymodels.org/) package and
[tidymodels.org](https://www.tidymodels.org/).

The name reflects the idea that tuning predictive models can be like
turning a set of dials on a complex machine under duress.

<img src="http://tos.trekcore.com/hd/albums/1x04hd/thenakedtimehd1013.jpg" width="576" alt="two Star Trek characters in front of a machine with many dials, lights, and buttons">

## Installation

You can install the released version of dials from
[CRAN](https://CRAN.R-project.org) with:

``` r
install.packages("dials")
```

You can install the development version from Github with:

``` r
# install.packages("pak")
pak::pak("tidymodels/dials")
```

## Contributing

Please note that the dials project is released with a [Contributor Code
of Conduct](https://dials.tidymodels.org/CODE_OF_CONDUCT.html). By
contributing to this project, you agree to abide by its terms.

- For questions and discussions about tidymodels packages, modeling, and
  machine learning, please [post on Posit
  Community](https://forum.posit.co/new-topic?category_id=15&tags=tidymodels,question).

- If you think you have encountered a bug, please [submit an
  issue](https://github.com/tidymodels/dials/issues).

- Either way, learn how to create and share a
  [reprex](https://reprex.tidyverse.org/articles/articles/learn-reprex.html)
  (a minimal, reproducible example), to clearly communicate about your
  code.

- Check out further details on [contributing guidelines for tidymodels
  packages](https://www.tidymodels.org/contribute/) and [how to get
  help](https://www.tidymodels.org/help/).
