% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diat_idap.R
\encoding{UTF-8}
\name{diat_idap}
\alias{diat_idap}
\title{Calculates the Indice Diatomique Artois-Picardie (IDAP)}
\usage{
diat_idap(resultLoad)
}
\arguments{
\item{resultLoad}{The resulting list obtained from the diat_loadData() function}
}
\description{
The input for all of these functions is the resulting dataframe (resultLoad) obtained from the diat_loadData() function
A CSV or dataframe cannot be used directly with these functions, they have to be loaded first with the diat_loadData() function
so the acronyms and species' names are recognized
References for the index:
\itemize{
\item Prygiel, J., & Coste, M. (1993). The assessment of water quality in the Artois-Picardie water basin (France) by the use of diatom indices. Hydrobiologia, 269(1), 343-349.
}

Sample data in the examples is taken from:
\itemize{
\item Nicolosi Gelis, María Mercedes; Cochero, Joaquín; Donadelli, Jorge; Gómez, Nora. 2020. "Exploring the use of nuclear alterations, motility and ecological guilds in epipelic diatoms as biomonitoring tools for water quality improvement in urban impacted lowland streams". Ecological Indicators, 110, 105951. https://doi.org/10.1016/j.ecolind.2019.105951
}
}
\examples{
\donttest{
# Example using sample data included in the package (sampleData):
data("diat_sampleData")
# First, the diat_loadData() function has to be called to read the data
# The data will be stored into a list (loadedData)
# And an output folder will be selected through a dialog box if resultsPath is empty
# In the example, a temporary directory will be used in resultsPath
df <- diat_loadData(diat_sampleData, resultsPath = tempdir())
idapResults <- diat_idap(df)
}
}
\keyword{bioindicator}
\keyword{biotic}
\keyword{diatom}
\keyword{ecology}
