% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diat_loadData.R
\encoding{UTF-8}
\name{diat_loadData}
\alias{diat_loadData}
\title{Loads the Data into DiaThor in the correct format}
\usage{
diat_loadData(species_df, isRelAb = FALSE, maxDistTaxa = 2, resultsPath)
}
\arguments{
\item{species_df}{The data frame with your species data. Species as rows, Samples as columns. If empty, a dialog box will prompt to import a CSV file}

\item{isRelAb}{Boolean. If set to 'TRUE' it means that your species' data is the relative abundance of each species per site. If FALSE, it means that it the data corresponds to absolute densities. Default = FALSE}

\item{maxDistTaxa}{Integer. Number of characters that can differ in the species' names when compared to the internal database's name in the heuristic search. Default = 2}

\item{resultsPath}{String. Path for the output data. If empty (default), it will prompt a dialog box to select an output folder}
}
\description{
Loads the CSV or dataframe file, sets the Output folder for the package, and conducts both an exact and an heuristic search of the species' names.

The input file for the package is a dataframe or an external CSV file. Species should be listed as rows, with species' names in column 1 (column name should be "species")
The other columns (samples) have to contain the abundance of each species (relative or absolute) in each sample.
The first row of the file has to contain the headers with the sample names. Remember that a column named "species" is mandatory, containing the species' names
If a dataframe is not specified as a parameter (species_df), the package will show a dialog box to search for the CSV file
A second dialog box will help set up an Output folder, where all outputs from the package will be exported to (dataframes, CSV files, plots in PDF)
The package also downloads and installs a wrapper for the 'Diat.Barcode' project. Besides citing the DiaThor package, the Diat.Barcode project should also be cited, as follows:
\itemize{
\item Rimet F., Gusev E., Kahlert M., Kelly M., Kulikovskiy M., Maltsev Y., Mann D., Pfannkuchen M., Trobajo R., Vasselon V., Zimmermann J., Bouchez A., 2019. Diat.barcode, an open-access curated barcode library for diatoms. Scientific Reports. https://www.nature.com/articles/s41598-019-51500-6
}
Sample data in the examples is taken from:
\itemize{
\item Nicolosi Gelis, María Mercedes; Cochero, Joaquín; Donadelli, Jorge; Gómez, Nora. 2020. "Exploring the use of nuclear alterations, motility and ecological guilds in epipelic diatoms as biomonitoring tools for water quality improvement in urban impacted lowland streams". Ecological Indicators, 110, 105951. https://doi:10.1016/j.ecolind.2019.105951
}
}
\keyword{bioindicator}
\keyword{biotic}
\keyword{diatom}
\keyword{ecology}
