% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em.R
\name{run_em}
\alias{run_em}
\title{Run EM on counts to estimate multinomial mixture model}
\usage{
run_em(x, eps = 1e-08, max_iter = 1000, psc = 1e-04,
  verbose = TRUE)
}
\arguments{
\item{x}{An SCE object.}

\item{eps}{Numeric threshold. The EM algorithm converges when the 
percent change in log likihood is less than \code{eps}.}

\item{max_iter}{The maximum number of iterations allowed to run.}

\item{psc}{Pseudocount to add to multinomial parameters 
to avoid collapsing likelihood to 0.}

\item{verbose}{Logical indicating verbosity.}
}
\value{
An SCE object.
}
\description{
Run expectation maximization (EM) to estimate the parameters of the 
multinomial mixture model. This function takes an SCE 
object as input, and returns an SCE object with the EM output. 
The number of clusters and their initialized multinomial means 
are taken from the initial clustering assignments calculated with 
\code{\link{initialize_clusters}}. The EM algorithm is run  
by repeatedly updating the membership probabilities and then 
estimating the MLE parameters of the multinomial mixture model.
The algorithm converges when the percent change in 
the log likihood is less than \code{eps}. If the 
algorithm doesn't converge by \code{max_iter}, it breaks off.
The posterior probability is the calculated by taking the 
sum of the likelihood fractions across the cell types.
}
