% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actogram.R
\name{actogram}
\alias{actogram}
\title{Plot a an single actogram over a period of time for a specific variable}
\usage{
actogram(df, activity, activity_alias, start, end, save = "actogram")
}
\arguments{
\item{df}{The dataframe containing the activity data}

\item{activity}{the name of activity}

\item{activity_alias}{A string containing the name of the activity to be
shown on the graph.}

\item{start}{The start day (in "\%Y-\%m-\%d" format).}

\item{end}{The end day (in "\%Y-\%m-\%d" format).}

\item{save}{if NULL, the image is not saved. Otherwise, this parameter will
be the name of the saved image. it should contain the path and name without
the extension.}
}
\value{
A ggplot2 object that contains the actogram plot
}
\description{
Takes an activity dataset as input and plot and save an actogram of the
specified activity column
}
\examples{
data("df516b_2")
df <- df516b_2
activity <- names(df)[2]
start <- "2020-05-01" # year-month-day
end <- "2020-08-13" # year-month-day
activity_alias <- "Motion Index"
my_actogram <- actogram(df, activity, activity_alias, start, end,
  save = NULL)
print(my_actogram)
}
