% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfc.R
\name{dfc}
\alias{dfc}
\title{Computes the Degree of Function coupling (DFC), Harmonic Part (HP) and Weekly
Lomb-Scargle Spectrum (LSP Spec) for one variable in an activity dataset.
The dataset should be digiRhythm friendly.}
\usage{
dfc(
  data,
  activity,
  sampling = 15,
  alpha = 0.05,
  harm_cutoff = 12,
  rolling_window = 7,
  plot = TRUE,
  plot_harmonic_part = TRUE,
  verbose = TRUE,
  plot_lsp = TRUE
)
}
\arguments{
\item{data}{The activity data set.}

\item{activity}{The name of the activity.}

\item{sampling}{The sampling period of the data set in minutes.
the Lomb Scargle Periodogram is computed.}

\item{alpha}{The significance level that should be used to determine the
significant frequency component.}

\item{harm_cutoff}{the order of the highest harmonic needed to be considered.
An integer equal to 1, 2, 3, ... Default is 12.}

\item{rolling_window}{The rolling window used to compute the LSP. Default is
7 days.}

\item{plot}{if TRUE, the DFC/HP plot will be shown.}

\item{plot_harmonic_part}{if TRUE, it shows the harmonic part in the DFC plot}

\item{verbose}{if TRUE, print weekly progress.}

\item{plot_lsp}{if TRUE, the LSP of each sliding week will be plotted}
}
\value{
A list containing 2 dataframe. DFC dataframe that contain the
results of a DFC computation and SPEC Dataframe that contains the result of
spectrum computation.
The DFC contains 3 columns:
** The date in format YYYY-MM-DD.
** The DFC computed using a @rolling_window days.
** The Harmonic Part (ratio).
Data are supposed to sampled with a specific smpling rate. It should be the
same sampling rate
as in the given argument @sampling
Missing days are not permitted. If you have data with half day, it should be
removed.
}
\description{
The computation of DFC/HP/LSP parameters is done using a rolling window. If
the rolling window is 7 days, first, we compute the parameters of Days 1-7
then, of days 2-8 and so on). For each window of the 7 days, the function
will compute the LSP spectrum to determine the power of each frequency. Using
Baluev (2008), we will compute the significance of the amplitude of each
frequency component and determine whether it is significant or not. Then, we
will have all the significant frequencies, whose amplitudes' summation will
be denominated as SUMSIG. Among all the available frequencies, some are
harmonic (those that correspond to waves of period 24h, 12h, 24h/3, 24h/4,
...). As a result, we will have frequency components that are significant and
harmonic, whose powers' summation is called SSH (sum significant and
harmonic). The summation of all frequency components up to a frequency
reflecting a 24h period is called SUMALL. Therefore, DFC and HP are computed
as follows:
}
\details{
DFC <- SSH / SUMSIG
HP <- SSH / SUMALL
}
\examples{
sampling_period <- 15 * 60 # seconds
two_weeks <- 2 * 7 * 24 * 60 * 60 # seconds
amplitude_24h <- 5
amplitude_12h <- 3
noise_sd <- 2
time_seq <- seq(0, two_weeks, by = sampling_period)
time_posix <- as.POSIXct(time_seq, origin = "1970-01-01")
sine_24h <- amplitude_24h * sin(2 * pi * time_seq / (24 * 60 * 60))
sine_12h <- amplitude_12h * sin(2 * pi * time_seq / (12 * 60 * 60))
noise <- rnorm(length(time_seq), mean = 0, sd = noise_sd)
data <- sine_24h + sine_12h + noise
df <- data.frame(time = time_posix, value = data)
names(df) <- c("datetime", "activity")
print(str(df))
my_lsp <- dfc(df, "activity", alpha = 0.05, harm_cutoff = 12, plot = TRUE)
}
