% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{ProbMatrixCellTypes-class}
\alias{ProbMatrixCellTypes-class}
\alias{ProbMatrixCellTypes}
\title{The Class ProbMatrixCellTypes}
\description{
The ProbMatrixCellTypes class is a data storage class that contains
information related to the cell composition matrices used for the simulation
of pseudo-bulk RNA-Seq samples. The matrix is stored in the
\code{prob.matrix} slot. The other of slots contain additional information
generated during the process and required in subsequent steps.
}
\details{
As described in Torroja and Sanchez-Cabo, 2019, the proportions are
constructed using six different methods in order to avoid biases due to the
composition of the simulated bulk samples. In \code{plots} slot, plots are
stored that visually represent the distribution of these probabilities in
order to provide a way to monitor the different sets of samples generated.
These plots can be shown using the \code{\link{showProbPlot}} function (see
\code{?\link{showProbPlot}} for more details).
}
\section{Slots}{

\describe{
\item{\code{prob.matrix}}{Matrix of cell proportions generated for the simulation of
bulk samples. Rows correspond to the bulk samples to be generated
(\eqn{i}), columns are the cell types present in the provided single-cell
data (\eqn{j}) and each entry is the proportion of \eqn{j} cell type in
\eqn{i} sample.}

\item{\code{cell.names}}{Matrix containing the names of the cells that will make up
each simulated pseudo-bulk sample.}

\item{\code{set.list}}{List of cells sorted according to the cell type they
belong to.}

\item{\code{set}}{Vector containing the cell names present in the object.}

\item{\code{plots}}{List of lists with plots showing the distribution of the cell
proportions generated by each method during the process. In each list,
\code{boxplot}, \code{violinplot}, \code{linesplot} or \code{ncelltypes}
can be found. Please see \code{\link{showProbPlot}} for more details.}

\item{\code{type.data}}{Character with the type of data contained: training or test.}
}}

\references{
Torroja, C. and Sánchez-Cabo, F. (2019). digitalDLSorter: A Deep
Learning algorithm to quantify immune cell populations based on scRNA-Seq
data. Frontiers in Genetics 10, 978. doi: \doi{10.3389/fgene.2019.00978}
}
