% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/export.R
\docType{methods}
\name{export}
\alias{export}
\alias{export-method}
\alias{export,MultivariateAnalysis-method}
\title{Export Results}
\usage{
export(object, ...)

\S4method{export}{MultivariateAnalysis}(object, file, flags = "-r9Xj", ...)
}
\arguments{
\item{object}{A \code{\linkS4class{CA}}, \code{\linkS4class{MCA}} or \code{\linkS4class{PCA}} object.}

\item{...}{Currently not used.}

\item{file}{A \code{\link{character}} string specifying the pathname of the zip file.}

\item{flags}{A \code{\link{character}} string of flags (see \code{\link[utils:zip]{utils::zip()}}).}
}
\description{
Creates a Zip archive of all results in CSV format.
}
\examples{
\dontrun{
## Load data
data("iris")

## Compute principal components analysis
X <- pca(iris, sup_quali = "Species")

## Export results
export(X, file = "results.zip")
}
}
\seealso{
\code{\link[utils:write.table]{utils::write.csv()}}, \code{\link[utils:zip]{utils::zip()}}

Other getters: 
\code{\link{get_contributions}()},
\code{\link{get_coordinates}()},
\code{\link{get_data}()},
\code{\link{get_eigenvalues}()}
}
\author{
N. Frerebeau
}
\concept{getters}
