% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{CA-class}
\alias{CA-class}
\alias{.CA}
\alias{BootstrapCA-class}
\alias{.BootstrapCA}
\title{CA Results}
\description{
An S4 class to store the results of a simple correspondence analysis.
}
\examples{
## Load data
data("zuni", package = "folio")

## The chi square of independence between the two variables
stats::chisq.test(zuni)

## Compute correspondence analysis
X <- ca(zuni)

## Get row coordinates
get_coordinates(X, margin = 1)

## Get column coordinates
get_coordinates(X, margin = 2)

## Get row distances to centroid
get_distances(X, margin = 1)

## Get row inertias
get_inertia(X, margin = 1)

## Get row contributions
get_contributions(X, margin = 1)

## Get eigenvalues
get_eigenvalues(X)
}
\seealso{
Other class: 
\code{\link{MultivariateAnalysis}},
\code{\link{MultivariateBootstrap}},
\code{\link{MultivariateResults}},
\code{\link{MultivariateSummary}},
\code{\link{PCA-class}}
}
\author{
N. Frerebeau
}
\concept{class}
