% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/predict.R
\docType{methods}
\name{predict}
\alias{predict}
\alias{predict,CA-method}
\alias{predict,PCA-method}
\title{Predict New Coordinates}
\usage{
\S4method{predict}{CA}(object, newdata, margin = 1)

\S4method{predict}{PCA}(object, newdata, margin = 1)
}
\arguments{
\item{object}{A \code{\linkS4class{CA}} or \code{\linkS4class{PCA}} object.}

\item{newdata}{An object of supplementary points coercible to a
\code{\link{matrix}} for which to compute principal coordinates.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscript which the
data will be predicted: \code{1} indicates individuals/rows (the default), \code{2}
indicates variables/columns.}
}
\value{
A \code{\link{data.frame}} of coordinates.
}
\description{
Predict the projection of new individuals/rows or variables/columns.
}
\examples{
## Create a matrix
A <- matrix(data = sample(1:10, 100, TRUE), nrow = 10, ncol = 10)

## Compute correspondence analysis
X <- ca(A, sup_row = 8:10, sup_col = 7:10)

## Predict new row coordinates
Y <- matrix(data = sample(1:10, 120, TRUE), nrow = 20, ncol = 6)
predict(X, Y, margin = 1)

## Predict new column coordinates
Z <- matrix(data = sample(1:10, 140, TRUE), nrow = 7, ncol = 20)
predict(X, Z, margin = 2)
}
\seealso{
Other multivariate analysis: 
\code{\link{ca}()},
\code{\link{pca}()}
}
\author{
N. Frerebeau
}
\concept{multivariate analysis}
