% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_ym.R
\name{date_ym}
\alias{date_ym}
\alias{is_date_ym}
\alias{as_date_ym}
\title{A Simple S3-Class for Year-Month Dates}
\usage{
date_ym(y, m)

is_date_ym(x)

as_date_ym(x)
}
\arguments{
\item{y}{year}

\item{m}{month (optional)}

\item{x}{any R object}
}
\value{
\code{date_ym} returns an object of type \code{date_ym}

\code{is_date_ym} returns \code{TRUE} or \code{FALSE} depending on whether its
argument is of type \code{date_ym} or not.

\code{as_date_ym} attempts to coerce its argument to \code{date_ym} type
}
\description{
A simple data type for storing year-month dates in a human readable integer
format, e.g.: December 2012 is stored as 201212. Supports simple arithmetics
(\code{+} and \code{-}) as well formatting.
}
\examples{
date_ym(2013, 12)

as_date_ym(201612)

}
\seealso{
\code{\link[=format.date_ym]{format.date_ym()}}

Other simple dates: \code{\link{date_yq}},
  \code{\link{date_y}}
}
\concept{simple dates}
