% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/first_day_of_month.R
\name{first_day_ym}
\alias{first_day_ym}
\alias{last_day_ym}
\title{Get First or Last Day of Month From Year and Month}
\usage{
first_day_ym(x, m = NULL)

last_day_ym(x, m = NULL)
}
\arguments{
\item{x}{Anything that can be coerced to a date with \code{\link[base:as.Date]{base::as.Date()}}}

\item{m}{Two integer (vectors). \code{m} is optional and the interpretation of
\code{x} will depend on whether \code{m} is supplied or not:
\itemize{
\item if only \code{x} is supplied, \code{x} will be passed to \code{\link[=as_date_ym]{as_date_ym()}}
(e.g. \code{x = 201604} means April 2016)
\item if \code{x} and \code{m} are supplied, \code{x} is interpreted as year and \code{m} as
month.
}}
}
\value{
a \link{Date}
}
\description{
Get First or Last Day of Month From Year and Month
}
\examples{

first_day_ym(2016, 1)
first_day_ym(201601)

}
\seealso{
\code{\link[=first_day_of_month]{first_day_of_month()}}

Other ym convenience functions: \code{\link{first_day_y}},
  \code{\link{format_ym}}
}
\concept{ym convenience functions}
