% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-progress.R
\name{progress2}
\alias{progress2}
\title{'Shiny' progress bar, but can run without reactive context}
\usage{
progress2(title, max = 1, ..., quiet = FALSE,
  session = shiny::getDefaultReactiveDomain(),
  shiny_auto_close = FALSE)
}
\arguments{
\item{title}{character, task description}

\item{max}{maximum number of items in the queue}

\item{...}{passed to \code{shiny::Progress$new(...)}}

\item{quiet}{suppress console output, ignored in shiny context.}

\item{session}{'shiny' session, default is current reactive domain}

\item{shiny_auto_close}{logical, automatically close 'shiny' progress bar
once current observer is over. Default is \code{FALSE}. If setting to
\code{TRUE}, then it's equivalent to
\code{p <- progress2(...); on.exit({p$close()}, add = TRUE)}.}
}
\value{
A list of functions:
\describe{
\item{\code{inc(detail, message = NULL, amount = 1, ...)}}{
Increase progress bar by \code{amount} (default is 1).
}
\item{\code{close()}}{
Close the progress
}
\item{\code{reset(detail = '', message = '', value = 0)}}{
Reset the progress to \code{value} (default is 0), and reset information
}
\item{\code{get_value()}}{
Get current progress value
}
\item{\code{is_closed()}}{
Returns logical value if the progress is closed or not.
}
}
}
\description{
'Shiny' progress bar, but can run without reactive context
}
\examples{

progress <- progress2('Task A', max = 2)
progress$inc('Detail 1')
progress$inc('Detail 2')
progress$close()

# Check if progress is closed
progress$is_closed()

# ------------------------------ Shiny Example ------------------------------
library(shiny)
library(dipsaus)

ui <- fluidPage(
  actionButtonStyled('do', 'Click Here', type = 'primary')
)

server <- function(input, output, session) {
  observeEvent(input$do, {
    updateActionButtonStyled(session, 'do', disabled = TRUE)
    progress <- progress2('Task A', max = 10, shiny_auto_close = TRUE)
    lapply(1:10, function(ii){
      progress$inc(sprintf('Detail \%d', ii))
      Sys.sleep(0.2)
    })
    updateActionButtonStyled(session, 'do', disabled = FALSE)
  })
}

if(interactive()){
  shinyApp(ui, server)
}

}
