% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-inputbindings.R
\name{registerInputBinding}
\alias{registerInputBinding}
\title{Register customized input to enable support by compound input}
\usage{
registerInputBinding(fname, pkg, shiny_binding, update_function = NULL)
}
\arguments{
\item{fname}{character, function name, such as \code{"textInput"}}

\item{pkg}{character, package name, like \code{"shiny"}}

\item{shiny_binding}{character, 'JavaScript' binding name.See examples}

\item{update_function}{character, update function such as \code{"shiny::textInput"}}
}
\value{
a list of binding functions, one is `JavaScript` object key in
\code{Shiny.inputBindings}, the other is `shiny` update function in R end.
}
\description{
Register customized input to enable support by compound input
}
\examples{

# register shiny textInput
registerInputBinding('textInput', 'shiny',
                     'shiny.textInput', 'shiny::updateTextInput')

# Register shiny actionLink
# In "Shiny.inputbindings", the binding name is "shiny.actionButtonInput",
# Shiny update function is "shiny::updateActionButton"
registerInputBinding('actionLink', 'shiny',
                     'shiny.actionButtonInput', 'shiny::updateActionButton')

}
