% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posts.R
\name{posts}
\alias{post_create}
\alias{post_get}
\alias{post_wikify}
\alias{posts}
\title{Work with posts}
\usage{
post_get(post_id, url = NULL, key = NULL, user = NULL, ...)

post_create(topic_id, text, url = NULL, key = NULL, user = NULL, ...)

post_wikify(post_id, url = NULL, key = NULL, user = NULL, ...)
}
\arguments{
\item{post_id}{A post id}

\item{url}{Base url for a Discourse installation. See \code{\link{disc_setup}}}

\item{key}{Your api key on the Discourse installation. See \code{\link{disc_setup}}}

\item{user}{Your user name on the Discourse installation. See \code{\link{disc_setup}}}

\item{...}{Named parameters passed on to \code{\link[httr]{GET}},
\code{\link[httr]{POST}}, \code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}

\item{topic_id}{A topic id}

\item{text}{Text to put in post}
}
\description{
Work with posts
}
\examples{
\dontrun{
# get a post
post_get(90)
post_get(120)
post_get(130)
post_get(155)
cat(post_get(155)$raw)

# create post, create topic first
topic_create("The problem with blue skies", text = "just saying and all that")
post_create(topic_id = 13, text = "There isn't a problem!")
x <- topic(13)

# edit the post
## NOT WORKING YET
# topic(13)
# post_edit(id = x$post_stream$posts$id[2],
#          text = "There isn't a problem at all!")

# Wikify a post
post_wikify(x$post_stream$posts$id[4])
}
}

