% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_afc_utils.R
\name{e_afcrow_3D}
\alias{e_afcrow_3D}
\title{AFC plot of individuals in 3D}
\usage{
e_afcrow_3D(
  modelo,
  axes = c(1, 2, 3),
  colorRow = "steelblue",
  cos2 = 0,
  colorCos = "firebrick",
  titulos = c("Bien Representados", "Mal Representados"),
  etq = T
)
}
\arguments{
\item{modelo}{an object of class CA [FactoMineR].}

\item{axes}{a numeric vector of length 3 specifying the dimensions to be plotted.}

\item{colorRow}{a color for the individuals well represented.}

\item{cos2}{a numeric value from 0 to 1 specifying the quality of the individuals.}

\item{colorCos}{a color for individuals badly represented.}

\item{titulos}{a character vector of length 2 specifying the titles to use on legend.}

\item{etq}{a boolean, whether to add label to graph or not.}
}
\value{
echarts4r plot
}
\description{
AFC plot of individuals in 3D
}
\examples{
p <- FactoMineR::CA(iris[, -5], graph = FALSE)
e_afcrow_3D(p)

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
