% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_R6_utils.R
\name{diseasyoption}
\alias{diseasyoption}
\title{Helper function to get options related to diseasy}
\usage{
diseasyoption(option, class = NULL, namespace = NULL, .default = NULL)
}
\arguments{
\item{option}{(\code{character(1)})\cr
Name of the option to get.}

\item{class}{(\code{character(1)} or \verb{R6::R6class Diseasy* instance})\cr
Either the classname or the object the option applies to.}

\item{namespace}{(\code{character(1)})\cr
The namespace of the option (e.g. "diseasy" or "diseasystore").}

\item{.default}{(\code{any})\cr
The default value to return if no option is set.}
}
\value{
\itemize{
\item If \code{option} is given, the most specific option within the \code{diseasy} framework for the given option and class.
\item If \code{option} is missing, all options related to \code{diseasy} packages.
}
}
\description{
Helper function to get options related to diseasy
}
\examples{
  # Retrieve default option for source conn
  diseasyoption("source_conn")

  # Retrieve DiseasystoreGoogleCovid19 specific option for source conn
  diseasyoption("source_conn", "DiseasystoreGoogleCovid19")

  # Try to retrieve specific option for source conn for a non existent / un-configured diseasystore
  diseasyoption("source_conn", "DiseasystoreNonExistent") # Returns default source_conn

  # Try to retrieve specific non-existent option
  diseasyoption("non_existent", "DiseasystoreGoogleCovid19", .default = "Use this")
}
