% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R
\name{formula,market_model-method}
\alias{formula,market_model-method}
\alias{market_model_formula}
\title{Market model formula.}
\usage{
\S4method{formula}{market_model}(x)
}
\arguments{
\item{x}{A market model object.}
}
\value{
The model's formula
}
\description{
Market model formula.
}
\details{
Market model formulas adhere to the following specification:

\code{quantity | price | subject | time ~ demand | supply}

where
\itemize{
\item{quantity} The model's traded (observed) quantity variable.
\item{price} The model's price variable.
\item{quantity} The model's subject (e.g. firm) identification variable.
\item{quantity} The model's time identification variable.
\item{demand} The right hand side of the model's demand equation.
\item{supply} The right hand side of the model's supply equation.
}

The \code{\linkS4class{diseq_stochastic_adjustment}} additionally specify
price dynamics by appending the right hand side of the equation at the end
of the formula, i.e.

\code{quantity | price | subject | time ~ demand | supply | price_dynamics}

The left hand side part of the model formula specifies the elements that
are needed for initializing the model. The market models of the package
prepare the data based on these four variables using their respective
identification assumptions. See \link[=market_models]{market model classes}
for more details.

The function provides access to the formula used in model initialization.
}
\examples{
\donttest{
model <- simulate_model(
  "diseq_stochastic_adjustment", list(
    # observed entities, observed time points
    nobs = 500, tobs = 3,
    # demand coefficients
    alpha_d = -0.1, beta_d0 = 9.8, beta_d = c(0.3, -0.2), eta_d = c(0.6, -0.1),
    # supply coefficients
    alpha_s = 0.1, beta_s0 = 5.1, beta_s = c(0.9), eta_s = c(-0.5, 0.2),
    # price equation coefficients
    gamma = 1.2, beta_p0 = 3.1, beta_p = c(0.8)
  ),
  seed = 31
)

# access the model's formula
formula(model)
}
}
