% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_disk.frame.r
\name{write_disk.frame}
\alias{write_disk.frame}
\alias{output_disk.frame}
\title{Write disk.frame to disk}
\usage{
write_disk.frame(
  diskf,
  outdir = tempfile(fileext = ".df"),
  nchunks = ifelse("disk.frame" \%in\% class(diskf), nchunks.disk.frame(diskf),
    recommend_nchunks(diskf)),
  overwrite = FALSE,
  shardby = NULL,
  partitionby = NULL,
  compress = 50,
  ...
)

output_disk.frame(...)
}
\arguments{
\item{diskf}{a disk.frame}

\item{outdir}{output directory for the disk.frame}

\item{nchunks}{number of chunks}

\item{overwrite}{overwrite output directory}

\item{shardby}{the columns to shard by}

\item{partitionby}{the columns to (folder) partition by}

\item{compress}{compression ratio for fst files}

\item{...}{passed to cmap.disk.frame}
}
\description{
Write a data.frame/disk.frame to a disk.frame location. If df is a data.frame
then using the as.disk.frame function is recommended for most cases
}
\examples{
cars.df = as.disk.frame(cars)

# write out a lazy disk.frame to disk
cars2.df = write_disk.frame(cmap(cars.df, ~.x[1,]), overwrite = TRUE)
collect(cars2.df)

# clean up cars.df
delete(cars.df)
delete(cars2.df)
}
