% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispRity-package.R
\name{BeckLee_disparity}
\alias{BeckLee_disparity}
\title{BeckLee_disparity}
\format{one \code{dispRity} object.}
\description{
An example of a \code{dispRity} object.
}
\details{
This matrix is based on the \code{\link{BeckLee}} dataset and split into 120 continuous subsets (\code{\link{chrono.subsets}}).
It was bootstrapped 100 times (\code{\link{boot.matrix}}) with four rarefaction levels.
Disparity was calculated as the \code{\link[base]{sum}} of the \code{\link{variances}} (\code{\link{dispRity}}).
}
\examples{
\dontrun{
## Loading the data
data(BeckLee_mat99)
data(BeckLee_tree)
data(BeckLee_ages)

## Creating the 7 subsets
subsets <- chrono.subsets(BeckLee_mat99, BeckLee_tree,
                          time = seq(from = 0, to = 120, by = 1),
                          method = "continuous", model = "proximity",
                          FADLAD = BeckLee_ages)

## Bootstrapping and rarefying
bootstraps <- boot.matrix(subsets, bootstraps = 100)

## Calculating disparity
BeckLee_disparity <- dispRity(bootstraps, metric = c(sum, variances))
}
}
\seealso{
BeckLee disparity
}
