% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhatt.coeff.R
\name{bhatt.coeff}
\alias{bhatt.coeff}
\title{Bhattacharrya Coefficient}
\usage{
bhatt.coeff(x, y, bw = bw.nrd0, ...)
}
\arguments{
\item{x, y}{two distributions.}

\item{bw}{the bandwidth size, either a \code{numeric} or a \code{function} (see \code{\link[stats]{bw.nrd0}}).}

\item{...}{optional arguments to be passed to the \code{bw} argument.}
}
\description{
Calculates the probability of overlap between two distributions.
}
\examples{
## Two dummy distributions
x <- rnorm(1000, 0, 1)
y <- rnorm(1000, 1, 2)

## What is the probability of overlap of these distributions?
bhatt.coeff(x, y)

}
\references{
Bhattacharyya A. \bold{1943}. On a measure of divergence between two statistical populations defined by their probability distributions. Bull. Calcutta Math. Soc., 35, pp. 99-109
}
\seealso{
\code{\link{test.dispRity}}, \code{\link{null.test}}.
}
\author{
Thomas Guillerme
}
