% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{make_grouping}
\alias{make_grouping}
\title{Grouping}
\usage{
make_grouping(data, grouping)
}
\arguments{
\item{data}{A data frame with the dissolution profile data in wide format
and a column for the distinction of the groups to be compared.}

\item{grouping}{A character string specifying the column in \code{data} that
contains the group names (i.e. a factorial variable, e.g., for the
differentiation of batches or formulations of a drug product).}
}
\value{
A logical vector of length \code{nrow(data)} where \code{TRUE}
represents the reference and \code{FALSE} represents the test group.
}
\description{
The function \code{make_grouping()} makes the grouping according to the
\code{grouping} column.
}
\details{
If one of the two levels of the \code{grouping} column is named
\dQuote{references} or \dQuote{References} or some abbreviation thereof
(in the extreme case just \dQuote{r}) this level will be used as reference
level. Otherwise the first level of the \code{grouping} column (according to
the level sorting of the column) will be assumed representing the reference
group.
}
\keyword{internal}
