% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull-density.R
\name{dtailw}
\alias{dtailw}
\title{TailW Density function}
\usage{
dtailw(x, threshold, scale, shape)
}
\arguments{
\item{x}{Sample data.}

\item{threshold}{Minimum value of the tail.}

\item{scale}{Scale parameter.}

\item{shape}{Shape parameter.}
}
\value{
Gives the density of the TailW. The length of the result is determined by the length of x.
}
\description{
This function computes the density of the tailW with the input sample data. The expression for the density used is:
\deqn{f(x, \alpha, \beta, \nu) = \alpha \beta (x + \nu)^{\beta -1} \exp(-\alpha(x + \nu)^{\beta} + \alpha \nu^{\beta})}
}
\examples{
# Generate random deviates from a weibull tail and plot the theoretical density.
scale <- 2
shape <- 1
threshold <- 1
x_seq <- seq(threshold, 5, length.out = 500)
theo_density <- dtailw(x_seq, threshold = threshold, scale = scale, shape = shape)
sample <- rtailw(500, threshold = threshold, scale = scale, shape = shape)
hist(sample, probability = TRUE)
lines(x = x_seq, y = theo_density, col = "red")
}
\keyword{TailW}
