% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distantia_dtw.R
\name{distantia_dtw}
\alias{distantia_dtw}
\title{Dynamic Time Warping Dissimilarity Analysis of Time Series Lists}
\usage{
distantia_dtw(tsl = NULL, distance = "euclidean")
}
\arguments{
\item{tsl}{(required, time series list) list of zoo time series. Default: NULL}

\item{distance}{(optional, character vector) name or abbreviation of the distance method. Valid values are in the columns "names" and "abbreviation" of the dataset \link{distances}. Default: "euclidean".}
}
\value{
data frame with columns:
\itemize{
\item \code{x}: time series name.
\item \code{y}: time series name.
\item \code{distance}: name of the distance metric.
\item \code{psi}: psi dissimilarity of the sequences \code{x} and \code{y}.
}
}
\description{
Minimalistic but slightly faster version of \code{\link[=distantia]{distantia()}} to compute dynamic time warping dissimilarity scores using diagonal least cost paths.
}
\examples{

#load fagus_dynamics as tsl
#global centering and scaling
tsl <- tsl_initialize(
  x = fagus_dynamics,
  name_column = "name",
  time_column = "time"
) |>
  tsl_transform(
    f = f_scale_global
  )

if(interactive()){
  tsl_plot(
    tsl = tsl,
    guide_columns = 3
    )
}

#dynamic time warping dissimilarity analysis
df_dtw <- distantia_dtw(
  tsl = tsl,
  distance = "euclidean"
)

df_dtw[, c("x", "y", "psi")]

#visualize dynamic time warping
if(interactive()){

  distantia_dtw_plot(
    tsl = tsl[c("Spain", "Sweden")],
    distance = "euclidean"
  )

}


}
\seealso{
Other distantia: 
\code{\link{distantia}()},
\code{\link{distantia_dtw_plot}()},
\code{\link{distantia_ls}()}
}
\concept{distantia}
