% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psi_distance_lock_step.R
\name{psi_distance_lock_step}
\alias{psi_distance_lock_step}
\title{Lock-Step Distance}
\usage{
psi_distance_lock_step(x = NULL, y = NULL, distance = "euclidean")
}
\arguments{
\item{x}{(required, zoo object or numeric matrix) a time series with no NAs. Default: NULL}

\item{y}{(zoo object or numeric matrix) a time series with the same columns as \code{x} and no NAs. Default: NULL}

\item{distance}{(optional, character vector) name or abbreviation of the distance method. Valid values are in the columns "names" and "abbreviation" of the dataset \link{distances}. Default: "euclidean".}
}
\value{
numeric
}
\description{
Demonstration function to compute the lock-step distance between two univariate or multivariate time series.

This function does not accept NA data in the matrices \code{x} and \code{y}.
}
\examples{
#distance metric
d <- "euclidean"

#simulate two time series
#of the same length
x <- zoo_simulate(
  name = "x",
  rows = 100,
  seasons = 2,
  seed = 1
)

y <- zoo_simulate(
  name = "y",
  rows = 100,
  seasons = 2,
  seed = 2
)

if(interactive()){
  zoo_plot(x = x)
  zoo_plot(x = y)
}

#sum of distances
#between pairs of samples
psi_distance_lock_step(
  x = x,
  y = y,
  distance = d
)
}
\seealso{
Other psi_demo: 
\code{\link{psi_auto_distance}()},
\code{\link{psi_auto_sum}()},
\code{\link{psi_cost_matrix}()},
\code{\link{psi_cost_path}()},
\code{\link{psi_cost_path_sum}()},
\code{\link{psi_distance_matrix}()},
\code{\link{psi_equation}()}
}
\concept{psi_demo}
